/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.MathHelper;
import java.util.List;
import org.lwjgl.opengl.GL11;

public abstract class TabScrolledText
extends TabBase {
    protected List<String> myText;
    protected int firstLine = 0;
    protected int maxFirstLine = 0;
    protected int numLines = 0;

    public TabScrolledText(GuiBase guiBase, int n, String string) {
        super(guiBase, n);
        this.maxHeight = 92;
        this.myText = this.getFontRenderer().listFormattedStringToWidth(string, this.maxWidth - 16);
        this.numLines = Math.min(this.myText.size(), (this.maxHeight - 24) / this.getFontRenderer().FONT_HEIGHT);
        this.maxFirstLine = this.myText.size() - this.numLines;
    }

    public abstract String getIcon();

    public abstract String getTitle();

    @Override
    protected void drawForeground() {
        this.drawTabIcon(this.getIcon());
        if (!this.isFullyOpened()) {
            return;
        }
        if (this.firstLine > 0) {
            this.gui.drawIcon("IconArrowUp1", this.posXOffset() + this.maxWidth - 20, this.posY + 16, 1);
        } else {
            this.gui.drawIcon("IconArrowUp0", this.posXOffset() + this.maxWidth - 20, this.posY + 16, 1);
        }
        if (this.firstLine < this.maxFirstLine) {
            this.gui.drawIcon("IconArrowDown1", this.posXOffset() + this.maxWidth - 20, this.posY + 76, 1);
        } else {
            this.gui.drawIcon("IconArrowDown0", this.posXOffset() + this.maxWidth - 20, this.posY + 76, 1);
        }
        this.getFontRenderer().drawStringWithShadow(this.getTitle(), this.posXOffset() + 18, this.posY + 6, this.headerColor);
        for (int i = this.firstLine; i < this.firstLine + this.numLines; ++i) {
            this.getFontRenderer().drawString(this.myText.get(i), this.posXOffset() + 2, this.posY + 20 + (i - this.firstLine) * this.getFontRenderer().FONT_HEIGHT, this.textColor);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.getTitle());
            return;
        }
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        int n4 = n - this.posX();
        int n5 = n2 - this.posY;
        if (!this.isFullyOpened()) {
            return false;
        }
        if (n4 < 108) {
            return super.onMousePressed(n, n2, n3);
        }
        this.firstLine = n5 < 52 ? MathHelper.clamp(this.firstLine - 1, 0, this.maxFirstLine) : MathHelper.clamp(this.firstLine + 1, 0, this.maxFirstLine);
        return true;
    }

    @Override
    public boolean onMouseWheel(int n, int n2, int n3) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (n3 > 0) {
            this.firstLine = MathHelper.clamp(this.firstLine - 1, 0, this.maxFirstLine);
            return true;
        }
        if (n3 < 0) {
            this.firstLine = MathHelper.clamp(this.firstLine + 1, 0, this.maxFirstLine);
            return true;
        }
        return false;
    }
}

